package com.biz.crm.nebular.activiti.act.req;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "ConfirmCommunicateReqVO", description = "确认沟通请求VO")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class ConfirmCommunicateReqVO {

    @ApiModelProperty(value = "节点ID", required = true)
    private String taskId;

    @ApiModelProperty(value = "操作用户", required = true)
    private String userCode;

    @ApiModelProperty(value = "操作用户岗位", required = true)
    private String userPosCode;

    @ApiModelProperty(value = "确认沟通内容", required = true)
    private String content;

}
