package com.biz.crm.nebular.dms.orderfeerate;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/1 11:36
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单费用限制信息的vo")
public class OrderFeeRateVo extends CrmExtTenVo {

    @ApiModelProperty(value = "维度")
    private String demension;

    @ApiModelProperty(value = "产品编码")
    private String productCode;

    @ApiModelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty(value = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty(value = "组织编码")
    private String orgCode;

    @ApiModelProperty(value = "组织名称")
    private String orgName;

    @ApiModelProperty(value = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "费用池类型")
    private String feeType;

    @ApiModelProperty(value = "每单使用百分比（0<=this<=100）")
    private BigDecimal rate;
}
