package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MdmCustomerCountReqVo", description = "小程序App报表")
@Accessors(chain = true)
public class MdmCustomerCountReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("时间类型 0：今天 1：本月；2 上月")
    private String timeType;

    @ApiModelProperty(value = "查询年月", required = true)
    private String yearMonth;

    @ApiModelProperty("区域")
    private String parentOrgName;

    @ApiModelProperty("办事处")
    private String orgName;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员名称")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("客户数量")
    private String  customerNumber;

    @ApiModelProperty("上月客户数量")
    private String  syCustNumber;

    @ApiModelProperty("上月客户数量")
    private String  fluctuateNumber;

    @ApiModelProperty("开始时间")
    private String startDate;

    @ApiModelProperty("结束时间")
    private String endDate;

    @ApiModelProperty("同比开始时间")
    private String thanStartDate;

    @ApiModelProperty("同比时间")
    private String thanEndDate;


}