package com.biz.crm.nebular.mdm.kms.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author zxw
 */
@ApiModel(value = "变价单据")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class KmsPriceVoucherVo {
    /**
     * 变价单编号
     */
    @ApiModelProperty(value = "变价单编号")
    private String orderNumber;

    /**
     * 变价单类型
     */
    @ApiModelProperty(value = "变价单类型")
    private String orderType;

    /**
     * 变价单日期
     */
    @ApiModelProperty(value = "变价单日期")
    private String orderDate;

    /**
     * 变价单金额
     */
    @ApiModelProperty(value = "变价单金额")
    private String orderAmount;

    /**
     * 供货单价（含税）
     */
    @ApiModelProperty(value = "供货单价（含税）")
    private String supplyUnitPriceTax;

    /**
     * 供货单价（税金）
     */
    @ApiModelProperty(value = "供货单价（税金）")
    private String supplyUnitTax;

    /**
     * 供货单价（不含税）
     */
    @ApiModelProperty(value = "供货单价（不含税）")
    private String supplyUnitTotalPrice;

    /**
     * 商超单价（不含税）
     */
    @ApiModelProperty(value = "商超单价（不含税）")
    private String kaUnitTotalPrice;

    /**
     * 商超单价（含税）
     */
    @ApiModelProperty(value = "商超单价（含税）")
    private String kaUnitPriceTax;

    /**
     * 商超单价（税金）
     */
    @ApiModelProperty(value = "商超单价（税金）")
    private String kaUnitTax;

    /**
     * 商品数量
     */
    @ApiModelProperty(value = "商品数量")
    private String kaNum;

    /**
     * 单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)
     */
    @ApiModelProperty(value = "单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)")
    private String invoicesSource;

    /**
     * 商超门店/大仓编号
     */
    @ApiModelProperty(value = "商超门店/大仓编号")
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @ApiModelProperty(value = "商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 售达方编码
     */
    @ApiModelProperty(value = "售达方编码")
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty(value = "售达方名称")
    private String soldToPartyName;

    /**
     * 送达方编码
     */
    @ApiModelProperty(value = "送达方编码")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty(value = "送达方名称")
    private String deliveryPartyName;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private String orderCreateDate;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private String orderUpdateDate;

    /**
     * 创建用户
     */
    @ApiModelProperty(value = "创建用户")
    private String orderCreateName;

    /**
     * 更新用户
     */
    @ApiModelProperty(value = "更新用户")
    private String orderUpdateName;
}