package com.biz.crm.nebular.dms.order;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.order.vo
 * @Description: TODO
 * @date 2021/1/29 上午11:44
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单行数据vo")
public class OrderDetailVo extends CrmExtTenVo {

    @ApiModelProperty(value = "订单id")
    private String orderCode;

    @ApiModelProperty(value = "分组编码")
    private String groupCode;

    @ApiModelProperty(value = "行号")
    private String lineNo;

    @ApiModelProperty(value = "行项目类型")
    private String lineType;

    @ApiModelProperty(value = "商品编码")
    private String productCode;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "规格")
    private String spec;

    @ApiModelProperty(value = "数量")
    private BigDecimal productNum;

    @ApiModelProperty(value = "总重量(克)")
    private BigDecimal weightOfGram;

    @ApiModelProperty(value = "总重量(千克)")
    private BigDecimal weightOfKilogram;

    @ApiModelProperty(value = "总重量(吨)")
    private BigDecimal weightOfTon;

    @ApiModelProperty(value = "销售单位编码")
    private String salesUnit;

    @ApiModelProperty(value = "销售单位名称")
    private String salesUnitName;

    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    @ApiModelProperty(value = "本行总金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "促销编码")
    private String promotionPolicyCode;

    @ApiModelProperty(value = "货补费用池编码")
    private String feeCode;

    @ApiModelProperty(value = "货补费用池编码")
    private String feeName;

    @ApiModelProperty(value = "促销名称")
    private String promotionPolicyName;

    @ApiModelProperty(value = "默认商品图片")
    private String imgUrl;

    @ApiModelProperty(value = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty(value = "算价是否成功标识(YesNoEnum)")
    private String calSucessFlag;

    @ApiModelProperty(value = "算价失败提示语")
    private String calSucessMsg;

}
