package com.biz.crm.nebular.mdm.product.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/7 13:01
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MdmProductAdviseAndPriceReqVo implements Serializable {

    @ApiModelProperty(value = "条件类型编码集合",notes = "商品价格查询时的必要字段")
    private List<String> conditionTypeCodeList;

    @ApiModelProperty(value = "客户编码",notes ="商品价格查询时的必要字段" )
    private String customerCode;


    /**
     * 客户组织
     */
    private String cusCode;

    /**
     * 客户组织编码
     */
    private String orgCode;

    /**
     * 产品编码集合
     */
    private List<String> productCodes;

    /**
     * 初始化方法
     * @param cusCode
     * @param orgCode
     * @param productCodes
     * @return
     */
    public static MdmProductAdviseAndPriceReqVo newInstance(String cusCode,String orgCode,List<String> productCodes){
        MdmProductAdviseAndPriceReqVo mdmProductAdviseAndPriceReqVo = new MdmProductAdviseAndPriceReqVo();
        mdmProductAdviseAndPriceReqVo.setCusCode(cusCode);
        mdmProductAdviseAndPriceReqVo.setOrgCode(orgCode);
        mdmProductAdviseAndPriceReqVo.setProductCodes(productCodes);
        return mdmProductAdviseAndPriceReqVo;
    }


}
