package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动执行;返回vo
 *
 * @author lf
 * @date 2020-12-30 19:45:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动执行;")
@SaturnEntity(name = "SfaVisitStepActivityExecutionRespVo", description = "活动执行;")
public class SfaVisitStepActivityExecutionRespVo extends CrmExtTenVo {
    @ApiModelProperty("拜访id")
    @SaturnColumn(description = "拜访id")
    private String visitId;

    @ApiModelProperty("活动执行类型(0-费用活动,1-陈列活动)")
    @SaturnColumn(description = "活动执行类型(0-费用活动,1-陈列活动)")
    private String activityType;

    @ApiModelProperty("活动执行类型(0-费用活动,1-陈列活动)")
    @CrmDict(typeCode = "sfa_activity_type",dictCodeField = "activityType")
    private String activityTypeDesc;

    @ApiModelProperty("活动执行id")
    private String activityExecutionId;

    @ApiModelProperty("网点id")
    @SaturnColumn(description = "网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    @SaturnColumn(description = "客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    private String clientType;

    @ApiModelProperty("活动执行时间")
    @SaturnColumn(description = "活动执行时间")
    private String activityTime;

    @ApiModelProperty("活动执行参数json")
    private String activityJson;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("活动执行地址")
    private String activityExecutionAddress;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("维度")
    private String latitude;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动执行开始时间")
    private String activityStartTime;

    @ApiModelProperty("活动执行结束时间")
    private String activityEndTime;

    @ApiModelProperty("活动频率(天/次)")
    private String activityFrequency;

}