package com.biz.crm.nebular.mdm.shoppingcart;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.poi.hpsf.Decimal;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/20 11:01
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "购物车VO")
public class ShoppingCartVo extends CrmExtVo {

    @ApiModelProperty(value = "账号")
    private String account;

    @ApiModelProperty(value = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "商品编码")
    private String goodsCode;

    @ApiModelProperty(value = "商品名称")
    private String goodsName;

    @ApiModelProperty(value = "数量")
    private Integer num;

    /***/
    @ApiModelProperty(value = "商品信息")
    private CusAvailablelistVo goodsInfo;

    /***/
    @ApiModelProperty(value = "发货公司编码")
    private String salesCompanyCode;

    /***/
    @ApiModelProperty(value = "发货公司")
    private String salesCompanyName;

    /***/
    @ApiModelProperty(value = "商品状态")
    private Integer goodsState;
}
