package com.biz.crm.nebular.sfa.worksign.form.resp;

import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordPictureRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName SfaSignDetailRespVo.java
 * @Description 考勤明细报表VO
 * @createTime 2020年11月25日 16:47:00
 */
@Data
@ApiModel("考勤明细报表VO")
public class SfaSignDetailRespVo {

    @ApiModelProperty("ID")
    private String id;
    @ApiModelProperty("账号")
    private String wsUserName;
    @ApiModelProperty("人员姓名")
    private String wsRealName;
    @ApiModelProperty("职位编码")
    private String wsPosCode;
    @ApiModelProperty("职位")
    private String wsPosName;
    @ApiModelProperty("组织编码")
    private String wsOrgCode;
    @ApiModelProperty("组织-办事处")
    private String wsOrgName;
    @ApiModelProperty("上级组织编码")
    private String wsParentOrgCode;
    @ApiModelProperty("上级组织-区域")
    private String wsParentOrgName;
    @ApiModelProperty("打卡类型")
    private String workSignType;
    @ApiModelProperty("打卡类型描述")
    private String workSignDesc;
    @ApiModelProperty("考勤时间(HH:mm:ss)")
    private String workSignTime;
    @ApiModelProperty("考勤日期")
    private String ruleDate;
    @ApiModelProperty("考勤地点")
    private String workSignPlace;
    @ApiModelProperty("考勤地点状态(1:正常;2:异常;)")
    private String wsPlaceStatus;
    @ApiModelProperty("打卡经度")
    private String lngIn;
    @ApiModelProperty("打卡纬度")
    private String latIn;
    @ApiModelProperty("考勤状态")
    private String workSignStatus;
    @ApiModelProperty("考勤状态描述")
    private String workSignStatusDesc;
    @ApiModelProperty("规则编码")
    private String ruleCode;
    @ApiModelProperty("规则名称")
    private String ruleName;
    @ApiModelProperty("规则类型")
    private String ruleType;
    @ApiModelProperty("规则类型描述")
    private String ruleTypeDesc;
    @ApiModelProperty("照片路径(物理路径)")
    private String picPath;
    @ApiModelProperty("照片地址")
    private String picUrl;
    List<SfaCheckInSignRecordPictureRespVo> signPictures;

}
