package com.biz.crm.nebular.sfa.worksummary.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工作总结照片信息返回vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作总结照片信息")
@SaturnEntity(name = "SfaWorkSummaryPictureRespVo", description = "工作总结照片信息")
public class SfaWorkSummaryPictureRespVo extends CrmBaseVo {
    private static final long serialVersionUID = 3936241954323397645L;
    @ApiModelProperty("图片对象名称")
    @SaturnColumn(description = "图片对象名称")
    private String objectName;

    @ApiModelProperty("图片相对路径")
    @SaturnColumn(description = "图片相对路径")
    private String urlPath;

    @ApiModelProperty("图片路径地址")
    @SaturnColumn(description = "图片路径地址")
    private String urlPathPrefix;

    @ApiModelProperty("工作总结ID")
    @SaturnColumn(description = "工作总结ID")
    private String businessId;

}