package com.biz.crm.nebular.dms.promotion.policy.resp;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 促销政策订单明细返回vo
 *
 * @author lf
 * @date 2020-12-26 13:34:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "促销政策订单明细")
@SaturnEntity(name = "DmsPromotionPolicyOrderDetailRespVo", description = "促销政策订单明细")
public class DmsPromotionPolicyOrderDetailRespVo extends CrmExtTenVo {
    @ApiModelProperty("明细状态 locked:已锁定, commit:已提交, unlock:解除锁定, rollback:已回滚")
    @SaturnColumn(description = "明细状态 locked:已锁定, commit:已提交, unlock:解除锁定, rollback:已回滚")
    private String policyOrderDetailStatus;

    @ApiModelProperty("促销政策id")
    @SaturnColumn(description = "促销政策id")
    private String promotionPolicyId;

    @ApiModelProperty("订单id")
    @SaturnColumn(description = "订单id")
    private String orderId;

    @ApiModelProperty("订单号")
    @SaturnColumn(description = "订单号")
    private String orderNo;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("政策使用量")
    @SaturnColumn(description = "政策使用量")
    private BigDecimal usedQty;

    @ApiModelProperty("政策使用量类型 QTY_TYPE number:数量, amount:金额")
    @SaturnColumn(description = "政策使用量类型 QTY_TYPE number:数量, amount:金额")
    private String usedQtyType;

    @ApiModelProperty("政策使用量单位 rmb:元, product_base_unit:基本单位, material_sale_unit:销售单位")
    @SaturnColumn(description = "政策使用量单位 rmb:元, product_base_unit:基本单位, material_sale_unit:销售单位")
    private String usedQtyUnit;

    @ApiModelProperty("命中该政策的明细数据")
    @SaturnColumn(description = "命中该政策的明细数据")
    private String hitDetail;

}