package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 折扣费用池使用金额请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDiscountUseReqVo", description = "折扣费用池使用金额请求VO")
public class FeePoolDiscountUseReqVo {

//    @ApiModelProperty("客户编码（必填）")
//    private String customerCode;

    @ApiModelProperty("折扣费用类型")
    private String discountType;

    @ApiModelProperty("使用金额（必填）")
    private BigDecimal amount;

//    @ApiModelProperty("来源单号")
//    private String fromCode;
//
//    @ApiModelProperty("来源描述")
//    private String fromDesc;
//
//    @ApiModelProperty("操作类型（必填）")
//    private String operationType;
//
    @ApiModelProperty("备注")
    private String remarks;
//
//    @ApiModelProperty("附件")
//    private List<FeePoolFileReqVo> fileList;
}