package com.biz.crm.nebular.sfa.integral.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 积分规则 请求vo
 *
 * @author YuanZiJian
 * @date 2021/1/8 14:09
 * @version: V1.0
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IntegralRuleReqVo", description = "积分规则 ")
public class SfaIntegralRuleReqVo extends CrmExtTenVo {


    @ApiModelProperty("批量操作的ID")
    private List<String> ids;

    @ApiModelProperty("积分规则名称")
    private String integralRuleName;

    @ApiModelProperty("开始时间")
    private String startTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("搜索条件:职位等级名称")
    private String posNameSearch;

    @ApiModelProperty("搜索条件:职位等级编码")
    private String posCodeSearch;

    @ApiModelProperty("搜索条件:组织名称")
    private String orgNameSearch;

    @ApiModelProperty("搜索条件:组织编码")
    private String orgCodeSearch;

    @ApiModelProperty("职位等级范围")
    private List<SfaIntegralRangeReqVo> posLevel;

    @ApiModelProperty("组织范围")
    private List<SfaIntegralRangeReqVo> orgs;

    @ApiModelProperty("计算规则")
    private List<SfaIntegralTaskReqVo> tasks;

}
