package com.biz.crm.nebular.sfa.worksummary.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工作总结评论记录返回vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作总结评论记录")
@SaturnEntity(name = "SfaWorkSummaryCommentRespVo", description = "工作总结评论记录")
public class SfaWorkSummaryCommentRespVo extends CrmBaseVo {
    private static final long serialVersionUID = -6582940276012733858L;
    @ApiModelProperty("评论内容")
    @SaturnColumn(description = "评论内容")
    private String comment;

    @ApiModelProperty("工作动态ID/评论ID")
    @SaturnColumn(description = "工作动态ID/评论ID")
    private String businessId;

    @ApiModelProperty("工作动态（总结）ID")
    @SaturnColumn(description = "工作动态（总结）ID")
    private String summaryId;

    @ApiModelProperty("人员信息")
    @SaturnColumn(description = "人员信息")
    private String userName;

    @ApiModelProperty("头像")
    @SaturnColumn(description = "头像")
    private String photo;

    @ApiModelProperty("点赞数")
    @SaturnColumn(description = "点赞数")
    private String likeSumCount;

    @ApiModelProperty("评论数")
    @SaturnColumn(description = "评论数")
    private String commentSumCount;

    @ApiModelProperty("是否已点赞(Y/N)")
    @SaturnColumn(description = "是否已点赞(Y/N)")
    private String liked;

    @ApiModelProperty("@人员集合")
    @SaturnColumn(description = "@人员集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSummaryAtLogRespVo> atLogRespVos;
}