package com.biz.crm.nebular.sfa.worksummary.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工作总结返回vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作总结")
@SaturnEntity(name = "SfaWorkSummaryRespVo", description = "工作总结")
public class SfaWorkSummaryPrimaryRespVo extends CrmBaseVo {
    private static final long serialVersionUID = 4262501296673501873L;
    @ApiModelProperty("动态")
    @SaturnColumn(description = "动态")
    private String dynamic;

    @ApiModelProperty("转发关联工作总结Id")
    @SaturnColumn(description = "转发关联工作总结Id")
    private String summaryId;

    @ApiModelProperty("工作总结")
    @SaturnColumn(description = "工作总结")
    private String summary;

    @ApiModelProperty("工作计划")
    @SaturnColumn(description = "工作计划")
    private String plan;

    @ApiModelProperty("类型(DAILY_日报,WEEKLY_周报,MONTHLY_月报,EXPERIENCE_心得)")
    @SaturnColumn(description = "类型(DAILY_日报,WEEKLY_周报,MONTHLY_月报,EXPERIENCE_心得)")
    private String lectureType;

    @ApiModelProperty("定位信息")
    @SaturnColumn(description = "定位信息")
    private String location;

    @ApiModelProperty("照片")
    @SaturnColumn(description = "照片")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSummaryPictureRespVo> pictureRespVos;

    @ApiModelProperty("转发数据")
    @SaturnColumn(description = "转发数据")
    private SfaWorkSummaryPrimaryRespVo forwardRespVos;

    @ApiModelProperty("@人员集合")
    @SaturnColumn(description = "@人员集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSummaryAtLogRespVo> atLogRespVos;

    @ApiModelProperty("头像")
    @SaturnColumn(description = "头像")
    private String photo;

    @ApiModelProperty("点赞数")
    @SaturnColumn(description = "点赞数")
    private String likeSumCount;

    @ApiModelProperty("评论数")
    @SaturnColumn(description = "评论数")
    private String commentSumCount;

    @ApiModelProperty("转发数")
    @SaturnColumn(description = "转发数")
    private String forwardSumCount;

    @ApiModelProperty("是否已点赞(Y/N)")
    @SaturnColumn(description = "是否已点赞(Y/N)")
    private String liked;
}