package com.biz.crm.nebular.tpm.costtypecategories.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 活动大类与活动细类的关联表 返回vo
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动大类与活动细类的关联表 ")
@CrmColumnResolve
@SaturnEntity(name = "TpmCostTypeCategoriesFineRespVo", description = "活动大类与活动细类的关联表 ")
public class TpmCostTypeCategoriesFineRespVo extends CrmExtVo {
    @ApiModelProperty("活动大类编码")
    @SaturnColumn(description = "活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("活动大类名称")
    private String categoriesName;


}
