package com.biz.crm.nebular.tpm.liqueuract.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动预算信息表;请求vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurActBudgetReqVo", description = "酒类活动预算信息表;")
public class TpmLiqueurActBudgetReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("费用预算控制维度id")
    private String controlId;

    @ApiModelProperty("费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("组织类型")
    private String orgType;

    @ApiModelProperty("审批金额")
    private BigDecimal approveAmount;

    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("可用金额")
    private BigDecimal canUseAmount;

    @ApiModelProperty("核销金额")
    private BigDecimal auditAmount;

    /**
     * 季度
     */
    private String budgetQuater;

    /**
     * 年
     */
    private String budgetYear;

    /**
     * 月
     */
    private String budgetMonth;
}
