package com.biz.crm.nebular.tpm.liqueuract.req;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 酒类活动附件信息;请求vo
 *
 * @author lf
 * @date 2021-03-08 18:33:23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurActRegisterDetailAttachReqVo", description = "酒类活动附件信息;")
public class TpmLiqueurActRegisterDetailAttachReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("附加信息编码")
    private String attachCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动细类名称")
    private String categoriesName;

    @ApiModelProperty("所属销售公司")
    private String ownedSalesCompany;

    @ApiModelProperty("所属客户")
    private String ownedCusCodes;

    @ApiModelProperty("支付类型")
    private String payType;

    @ApiModelProperty("归属客户编码")
    private String attributionCusCode;

    @ApiModelProperty("归属季度")
    private String attributionQuarter;

    @ApiModelProperty("归属月份")
    private String attributionMonth;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品类型")
    private String productType;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("单价")
    private BigDecimal univalent;

    @ApiModelProperty("申请数量")
    private String applyNumber;

    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("审批数量")
    private String approvalNumber;

    @ApiModelProperty("审批金额")
    private BigDecimal approvalAmount;

    @ApiModelProperty("支付人")
    private String payMan;

    @ApiModelProperty("开户行")
    private String accountBank;

    @ApiModelProperty("账号")
    private String account;

}