package com.biz.crm.nebular.tpm.liqueuract.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetRespVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 酒类活动明细主表;请求vo
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurActRegisterReqVo", description = "酒类活动明细主表;")
public class TpmLiqueurActRegisterReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动类型(细类名称)")
    private String fineCode;

    @ApiModelProperty("活动类型名称")
    private String fineName;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("登记总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("审批状态")
    private String approveStatus;

    /**
     * 用于修改 活动剩余可用金额
     */
    @ApiModelProperty("活动预算关联信息")
    private List<TpmLiqueurActBudgetRespVo> actBudgetRespVos;

    /**
     * 编辑查看 预算 信息 展示
     */
    @ApiModelProperty("预算信息")
    private List<TpmFeeBudgetControlRespVo> controlRespVos;

    @ApiModelProperty("活动明细")
    private List<TpmLiqueurActRegisterDetailReqVo> actDetailReqVos;
}