package com.biz.crm.nebular.tpm.liqueuract.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 酒类活动明细关联的活动费用预算表返回vo
 *
 * @author lf
 * @date 2021-03-10 13:41:58
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动明细关联的活动费用预算表")
@SaturnEntity(name = "TpmLiqueurActRegisterDetailBudgetRespVo", description = "酒类活动明细关联的活动费用预算表")
public class TpmLiqueurActRegisterDetailBudgetRespVo extends CrmExtVo {
    @ApiModelProperty("活动明细编码")
    @SaturnColumn(description = "活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动预算编码")
    @SaturnColumn(description = "活动预算编码")
    private String actBudgetCode;

    @ApiModelProperty("费用预算控制维度id")
    @SaturnColumn(description = "费用预算控制维度id")
    private String controlId;

    @ApiModelProperty("费用预算编码")
    @SaturnColumn(description = "费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("当前活动明细使用活动预算的金额")
    @SaturnColumn(description = "当前活动明细使用活动预算的金额")
    private BigDecimal usedAmount;

}