package com.biz.crm.nebular.tpm.liqueuract.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 酒类活动明细主表;返回vo
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动明细主表;")
@SaturnEntity(name = "TpmLiqueurActRegisterRespVo", description = "酒类活动明细主表;")
public class TpmLiqueurActRegisterRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String actName;

    @ApiModelProperty("登记总金额")
    @SaturnColumn(description = "登记总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("流程编号")
    @SaturnColumn(description = "流程编号")
    private String processCode;

    @ApiModelProperty("审批状态")
    @SaturnColumn(description = "审批状态")
    private String approveStatus;

}