package com.biz.crm.nebular.mdm.user.resp;

import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户关联微信返回vo
 *
 * @author Tao.Chen
 * @date 2021-02-19 16:39:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户关联微信")
public class MdmUserRelWeChatRespVo extends UuidVo {

    @ApiModelProperty("微信来源模块")
    private String originModule;

    @ApiModelProperty("微信来源模块")
    private String originModuleName;

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("微信openId")
    private String openId;

    @ApiModelProperty("当前是否处于登录状态")
    private String loginStatus;

    @ApiModelProperty("微信头像")
    private String headImgUrl;

    @ApiModelProperty("微信昵称")
    private String nickName;

}