package com.biz.crm.nebular.sfa.worksummary.req;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 工作总结可见权限请求vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSummaryScopeReqVo", description = "工作总结可见权限")
public class SfaWorkSummaryScopeReqVo extends CrmBaseVo {

    private static final long serialVersionUID = 6412578217817319350L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("权限类型")
    private String scopeType;

    @ApiModelProperty("权限范围code（组织code/人员code）")
    private String scopeCode;

    @ApiModelProperty("计数")
    private Integer scopeCount;

    @ApiModelProperty("工作总结动态ID")
    private String businessId;

}