package com.biz.crm.nebular.tpm.liqueuract.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 酒类活动附件信息;请求vo
 *
 * @author lf
 * @date 2021-03-08 18:06:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurActRegisterDetailReqVo", description = "酒类活动附件信息;")
public class TpmLiqueurActRegisterDetailReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动登记单号")
    private String actRegisterCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动细类名称")
    private String actDetailName;

    @ApiModelProperty("活动明细关联预算编码")
    private String actBudgetCodes;

    @ApiModelProperty("活动明细关联的预算控制维度")
    private List<TpmFeeBudgetControlRespVo> controlList;

    @ApiModelProperty("负责人")
    private String chargeMan;

    @ApiModelProperty("举办单位")
    private String organizer;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("经销商编码")
    private String dealerCode;

    @ApiModelProperty("兑付类型")
    private String redeemType;

    @ApiModelProperty("宴席类型")
    private String banquetType;

    @ApiModelProperty("区域（组织）")
    private String orgCode;

    @ApiModelProperty("业务（职位）编码")
    private String positionCode;

    @ApiModelProperty("红包计划发放目的")
    private String redEnvelopePlanPurpose;

    @ApiModelProperty("陈列任务")
    private String displayTask;

    @ApiModelProperty("三节团拜对象类型")
    private String threeFestivalsType;

    @ApiModelProperty("登记（申请金额）")
    private BigDecimal applyAmount;

    @ApiModelProperty("明细附加信息")
    private String detailAttachCode;

    @ApiModelProperty("是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否需要核销")
    private String isAudit;

    @ApiModelProperty("核销截至日期")
    private String allowAuditEndDate;

    @ApiModelProperty("核销截至日期时间")
    private String allowAuditEndDateSecond;

    @ApiModelProperty("核销金额")
    private String  auditAmount;

    @ApiModelProperty("开始时间")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束时间")
    private String endData;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("活动明细附加信息")
    private List<TpmLiqueurActRegisterDetailAttachReqVo> attachReqVos;

    @ApiModelProperty("活动明细选择的预算信息")
    private List<TpmLiqueurActRegisterDetailBudgetReqVo> budgetReqVos;
}