package com.biz.crm.nebular.tpm.liqueuract.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 活动预算信息表;返回vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动预算信息表;")
@CrmColumnResolve
@SaturnEntity(name = "TpmLiqueurActBudgetRespVo", description = "酒类活动预算信息表;")
public class TpmLiqueurActBudgetRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("费用预算编码")
    @SaturnColumn(description = "费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("费用预算控制维度id")
    @SaturnColumn(description = "费用预算控制维度id")
    private String controlId;

    @ApiModelProperty("费用预算类型(字典)")
    @SaturnColumn(description = "费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("组织类型")
    @SaturnColumn(description = "组织类型")
    private String orgType;

    @ApiModelProperty("审批金额")
    private BigDecimal approveAmount;

    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("可用金额")
    private BigDecimal canUseAmount;

    @ApiModelProperty("核销金额")
    private BigDecimal auditAmount;
}