package com.biz.crm.nebular.tpm.liqueuract.resp;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 酒类活动附件信息;返回vo
 *
 * @author lf
 * @date 2021-03-08 18:06:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动附件信息;")
@SaturnEntity(name = "TpmLiqueurActRegisterDetailRespVo", description = "酒类活动附件信息;")
public class TpmLiqueurActRegisterDetailRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动登记单号")
    private String actRegisterCode;

    @ApiModelProperty("活动明细编码")
    @SaturnColumn(description = "活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动细类名称")
    @SaturnColumn(description = "活动细类名称")
    private String actDetailName;

    @ApiModelProperty("活动明细关联预算编码")
    @SaturnColumn(description = "活动明细关联预算编码")
    private String actBudgetCodes;

    @ApiModelProperty("负责人")
    @SaturnColumn(description = "负责人")
    private String chargeMan;

    @ApiModelProperty("举办单位")
    @SaturnColumn(description = "举办单位")
    private String organizer;

    @ApiModelProperty("终端编码")
    @SaturnColumn(description = "终端编码")
    private String terminalCode;

    @ApiModelProperty("经销商编码")
    @SaturnColumn(description = "经销商编码")
    private String dealerCode;

    @ApiModelProperty("兑付类型")
    @SaturnColumn(description = "兑付类型")
    private String redeemType;

    @ApiModelProperty("宴席类型")
    @SaturnColumn(description = "宴席类型")
    private String banquetType;

    @ApiModelProperty("区域（组织）")
    @SaturnColumn(description = "区域（组织）")
    private String orgCode;

    @ApiModelProperty("业务（职位）编码")
    @SaturnColumn(description = "业务（职位）编码")
    private String positionCode;

    @ApiModelProperty("红包计划发放目的")
    @SaturnColumn(description = "红包计划发放目的")
    private String redEnvelopePlanPurpose;

    @ApiModelProperty("陈列任务")
    @SaturnColumn(description = "陈列任务")
    private String displayTask;

    @ApiModelProperty("三节团拜对象类型")
    @SaturnColumn(description = "三节团拜对象类型")
    private String threeFestivalsType;

    @ApiModelProperty("登记（申请金额）")
    @SaturnColumn(description = "登记（申请金额）")
    private BigDecimal applyAmount;

    @ApiModelProperty("明细附加信息")
    @SaturnColumn(description = "明细附加信息")
    private String detailAttachCode;

    @ApiModelProperty("是否完全核销")
    @SaturnColumn(description = "是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否需要核销")
    @SaturnColumn(description = "是否需要核销")
    private String isAudit;

    @ApiModelProperty("核销截至日期")
    @SaturnColumn(description = "核销截至日期")
    private String allowAuditEndDate;

    @ApiModelProperty("核销截至日期时间")
    @SaturnColumn(description = "核销截至日期时间")
    private String allowAuditEndDateSecond;

    @ApiModelProperty("核销金额")
    @SaturnColumn(description = "核销金额")
    private String  auditAmount;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDate;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endData;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endDateSecond;
    

}