package com.biz.crm.nebular.tpm.liqueuraudit.req;

import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditDetailsRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditFileRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 酒类TPM核销申请主表;请求vo
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurAuditReqVo", description = "酒类TPM核销申请主表;")
public class TpmLiqueurAuditReqVo extends PageVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("核销申请名称")
    private String auditName;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动明细列表")
    private List<TpmLiqueurAuditDetailsRespVo> detailsRespVos;

    @ApiModelProperty("保存类型:1新增暂存,2,新增并提交审批,3,修改暂存,4修改并提交审批,5,提交审批")
    private String saveType;

    @ApiModelProperty("核销资料列表")
    private List<TpmLiqueurAuditFileRespVo> auditFileRespVos;

}