package com.biz.crm.nebular.sfa.achievement.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 绩效规则 请求vo
 *
 * @author yangshan
 * @date 2021-2-25 12:56:27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAchievementRuleReqVo", description = "绩效规则")
public class SfaAchievementRuleTableReqVo extends CrmExtTenVo {

    /**
     * 对象编码
     */
    @ApiModelProperty("对象编码")
    private String objectCode;

    /**
     * 对象名称
     */
    @ApiModelProperty("对象名称")
    private String objectName;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String objectPosName;

    /**
     * 绩效时间
     */
    @ApiModelProperty("绩效时间")
    private String achievementDate;
    /**
     * 绩效时间年份
     */
    @ApiModelProperty("绩效时间年份")
    private String achievementDateYear;
    /**
     * 绩效时间月份
     */
    @ApiModelProperty("绩效时间月份")
    private String achievementDateMonth;
    /**
     * 绩效时间旬度
     */
    @ApiModelProperty("绩效时间旬度")
    private String achievementDateTenDays;

    /**
     * 开始时间（用于查询记录）
     */
    @ApiModelProperty("绩效开始时间（自由时间）")
    private String beginDate;

    /**
     * 结束时间（用于查询记录）
     */
    @ApiModelProperty("绩效结束时间（自由时间）")
    private String endDate;

    /**
     * 绩效类型
     */
    @ApiModelProperty("绩效类型")
    private String achievementType;

    /**
     * 指标编码
     */
    @ApiModelProperty("指标编码")
    private String indexCode;

    /**
     * 指标名称
     */
    @ApiModelProperty("指标名称")
    private String indexName;

    /**
     * 权重
     */
    @ApiModelProperty("权重")
    private String weight;

    /**
     * 目标数量
     */
    @ApiModelProperty("目标数量")
    private String targetNum;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String unit;
}
