package com.biz.crm.nebular.sfa.assistant.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 工作任务(发布) 请求vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkTaskReleaseReqVo", description = "工作任务(发布) ")
public class SfaWorkTaskReleaseReqVo extends CrmExtTenVo {
    @ApiModelProperty("任务id")
    private String taskId;

    @ApiModelProperty("任务标题")
    private String taskTitle;

    @ApiModelProperty("任务进度")
    private String progress;

    @ApiModelProperty("任务状态 0待执行 1部分完成 2已完成 3未完成 4已拒绝 5已过期")
    private String taskStatus;

    @ApiModelProperty("开始时间")
    private String startDate;

    @ApiModelProperty("结束时间")
    private String endDate;

    @ApiModelProperty("任务地点")
    private String taskSite;
    
    @ApiModelProperty("任务详情")
    private String content;

    @ApiModelProperty("人员详情")
    private List<SfaStaffMessageReqVo> sfaStaffMessageReqVos;

    @ApiModelProperty("创建时间开始")
    private String startDateOne;

    @ApiModelProperty("创建时间结束")
    private String startDateTwo;

    @ApiModelProperty("截止时间开始")
    private String overDateOne;

    @ApiModelProperty("截止时间结束")
    private String overDateTwo;

    @ApiModelProperty("图片集合")
    private List<SfaWorkTaskPictureReqVo> pictures;

    @ApiModelProperty("执行对象集合")
    private List<SfaWorkTaskObjectReqVo> taskObjects;





}