package com.biz.crm.nebular.sfa.helpdefense.resp.step;


import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 加载协访任务执行信息
 *  @author: luoqi
 *  @Date: 2021-1-22 16:04
 *  @version: V1.0
 *  @Description:
 */
@Data
@ApiModel("加载协访任务执行信息响应对象")
public class LoadHelpDefenseExecutionInfoRespVo<T extends HelpDefenseStepInfoVo> {

    /**
     * 网点图片
     */
    @ApiModelProperty("网点图片")
    private String clientPhoto;
    @ApiModelProperty("协访网点名称")
    private String clientName;
    @ApiModelProperty("协访网点编码")
    private String clientCode;
    @ApiModelProperty("业务员姓名")
    private String realName;

    @ApiModelProperty("进店执行信息")
    private T helpDefenseStepInfoVoAsInStore;

    @ApiModelProperty("拜访内容")
    private VisitInfo<T> visitInfo;

    @ApiModelProperty("离店执行信息")
    private T helpDefenseStepInfoVoAsOutStore;

    @Data
    public static class VisitInfo<T extends HelpDefenseStepInfoVo>{
        @ApiModelProperty("协访步骤执行列表信息")
        private List<T> helpDefenseStepInfoVos;

        @ApiModelProperty("拜访内容")
        private String helpDefenseSummary;

        @ApiModelProperty("重点问题记录")
        private String keyQuestions;
    }
}
