package com.biz.crm.nebular.sfa.moblie.req;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.customer.MdmCustomerBillReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * sfa新增修改终端审批Vo
 * @author YuanZiJian
 * @date 2021/3/9 14:25
 * @version: V1.0
 */
@Data
@ApiModel(value = "SfaTerminalMsgReqVo", description = "SFA客户审批信息")
@Accessors(chain = true)
public class SfaTerminalMsgReqVo {
    @ApiModelProperty("审批id——PS：更新审批时传入对应id")
    private String id;
    @ApiModelProperty("终端编码")
    private String terminalCode;
    @ApiModelProperty("终端名称")
    private String terminalName;
    @ApiModelProperty("终端类型")
    private String terminalType;
    @ApiModelProperty("终端类型名称")
    @CrmDict(typeCode = DictConstant.TERMINAL_TYPE,dictCodeField = "terminalType")
    private String terminalTypeName;
    @ApiModelProperty("渠道")
    private String channel;
    @ApiModelProperty("渠道名字")
    @CrmDict(typeCode = DictConstant.CHANNEL,dictCodeField = "channel")
    private String channelName;
    @ApiModelProperty("营业执照法人姓名")
    private String licensePersonName;
    @ApiModelProperty("营业执照注册号")
    private String licenseRegisterNumber;
    @ApiModelProperty("营业执照企业名称")
    private String licenseFirmName;
    @ApiModelProperty("终端地址")
    private String terminalAddress;
    @ApiModelProperty("店招照片")
    private String shopImagePath;
    @ApiModelProperty("营业执照照片")
    private String licenseImagePath;
    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;
    @ApiModelProperty("客户分类")
    private String customerClassification;
    @ApiModelProperty("审批状态,枚举ActApproveStatusEnum")
    private String actApproveStatus;
    @ApiModelProperty("联系人信息集合")
    private List<MdmTerminalContactVo> contacts;
    @ApiModelProperty("供货关系集合")
    private List<MdmTerminalSupplyVo> supplys;
    @ApiModelProperty("备注")
    private String remarks;
}
