package com.biz.crm.nebular.sfa.picture.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访相关照片信息 返回vo
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访相关照片信息 ")
@SaturnEntity(name = "SfaVisitPictureRespVo", description = "拜访相关照片信息 ")
public class SfaVisitPictureRespVo extends CrmExtTenVo {
    @ApiModelProperty("标题")
    @SaturnColumn(description = "标题")
    private String title;

    @ApiModelProperty("照片类型")
    @SaturnColumn(description = "照片类型")
    private String picType;

    @ApiModelProperty("照片路径")
    @SaturnColumn(description = "照片路径")
    private String picPath;

    @ApiModelProperty("照片地址")
    @SaturnColumn(description = "照片地址")
    private String picUrl;

    @ApiModelProperty("照片描述")
    @SaturnColumn(description = "照片描述")
    private String picDesc;

    @ApiModelProperty("拜访编码")
    @SaturnColumn(description = "拜访编码")
    private String visitId;

    @ApiModelProperty("业务明细关联")
    @SaturnColumn(description = "业务明细关联")
    private String businessId;

}