package com.biz.crm.nebular.sfa.visitstep.req;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访步骤控件——新增编辑Vo
 * @author YuanZiJian
 * @date 2021/2/4 14:05
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤控件新增编辑")
@SaturnEntity(name = "SfaVisitStepFromControlReqVo", description = "拜访步骤控件新增编辑")
public class SfaVisitStepFromControlReqVo {
    /**
     * 控件名称
     */
    @ApiModelProperty("控件名称")
    private String controlName;
    /**
     * 控件类型（数据字典：SFAcontrolType）
     */
    @ApiModelProperty("控件类型")
    private String controlType;

    /**
     * 控件对应的数据字典
     */
    @ApiModelProperty("数据字典")
    private String dictCode;

    /**
     * 扩展参数
     */
    @ApiModelProperty("扩展参数")
    private String extendParam;

    /**
     * 是否必填（Yes/No）
     */
    @ApiModelProperty("是否必填（Yes/No）")
    private String requireType;
    /**
     * 排序
     */
    @ApiModelProperty("排序")
    private String sort;

    /**
     * 对应的字段名
     */
    @ApiModelProperty("字段名")
    private String fieldName;
    /**
     * 备注
     */
    @ApiModelProperty("备注——必填")
    private String remarks;
}
