package com.biz.crm.nebular.sfa.visitstepdetail.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 拜访步骤(库存盘点);请求vo
 *
 * @author lf
 * @date 2020-12-29 11:35:55
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepStockInventoryReqVo", description = "拜访步骤(库存盘点);")
public class SfaVisitStepStockInventoryReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访id")
    private String visitId;

    @ApiModelProperty("网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    private String clientType;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("盘库时间")
    private String stockTime;

    @ApiModelProperty("盘库地址")
    private String stockAddress;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("盘库时间列表")
    private List<String> stockTimeList;

    @ApiModelProperty("网点编码列表")
    private List<String> clientCodeList;

    @ApiModelProperty("开始盘库时间")
    private String startStockTime;

    @ApiModelProperty("结束盘库时间")
    private String endStockTime;

}