package com.biz.crm.nebular.tpm.liqueuract.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 酒类活动明细关联的活动费用预算表请求vo
 *
 * @author lf
 * @date 2021-03-10 13:41:58
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurActRegisterDetailBudgetReqVo", description = "酒类活动明细关联的活动费用预算表")
public class TpmLiqueurActRegisterDetailBudgetReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动申请单号")
    private String actCode;


    @ApiModelProperty("活动登记单号")
    private String actRegisterCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动预算编码")
    private String actBudgetCode;

    @ApiModelProperty("费用预算控制维度id")
    private String controlId;

    @ApiModelProperty("费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("当前活动明细使用活动预算的金额")
    private BigDecimal usedAmount;

}