package com.biz.crm.nebular.tpm.liqueuract.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 酒类活动明细主表;返回vo
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动登记主表;")
public class TpmLiqueurActRegisterRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动登记单号")
    private String actRegisterCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("登记总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("审批状态")
    private String approveStatus;

    @ApiModelProperty("审批状态名称")
    private String approveStatusName;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("预算信息集合")
    private List<TpmLiqueurActRegisterDetailBudgetRespVo> budgetRespVoList;

    @ApiModelProperty("活动细明登记集合")
    private List<TpmLiqueurActRegisterDetailRespVo> detailRespVoList;

    @ApiModelProperty("附加信息集合")
    private List<TpmLiqueurActRegisterDetailAttachRespVo> attachRespVoList;


}
