package com.biz.crm.nebular.tpm.liqueuraudit.req;

import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 酒类tpm核销明细表请求vo
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurAuditDetailsReqVo", description = "酒类tpm核销明细表")
public class TpmLiqueurAuditDetailsReqVo extends TpmLiqueurActRegisterDetailReqVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("活动登记明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动登记编码")
    private String actRegisterCode;

    @ApiModelProperty("核销金额")
    private BigDecimal amount;

    @ApiModelProperty("是否完全核销（Y/N）")
    private String isAllAudit;

    @ApiModelProperty("已上账金额")
    private BigDecimal feeUsed;

    @ApiModelProperty("是否完全上账（Y/N）")
    private String isAllFeeUsed;

}