package com.biz.crm.nebular.mdm.approval.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 审批配置主表返回vo
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "审批配置主表")
@CrmColumnResolve
public class MdmApprovalConfigRespVo extends CrmBaseVo {

    @ApiModelProperty("菜单编码")
    private String menuCode;

    @ApiModelProperty("菜单名称")
    private String menuName;

    @ApiModelProperty("业务编码")
    private String businessCode;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("审批开关：1是 0否")
    private String controlFlag;

    @ApiModelProperty("审批类型")
    private String approvalType;

    @ApiModelProperty("控制范围")
    private String controlScope;

    @ApiModelProperty("条件运算方式")
    private String conditionLogicalType;

    @ApiModelProperty("自定义运算逻辑")
    private String designLogical;

    @ApiModelProperty("条件字段集合")
    private List<MdmApprovalConfigConditionRespVo> conditionList;

}