package com.biz.crm.nebular.mdm.product.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class MdmProductQueryReqVo {

    @ApiModelProperty("商品编码（精确查询）")
    private String productCode;

    @ApiModelProperty("商品编码集合（精确查询）")
    private List<String> productCodeList;

    @ApiModelProperty("商品名称（模糊查询）")
    private String productName;

    @ApiModelProperty("产品层级编码（精确查询）")
    private String productLevelCode;

    @ApiModelProperty("产品层级编码集合（精确查询）")
    private List<String> productLevelCodeList;

    @ApiModelProperty("产品层级编码（查询全部下级层级（含当前））")
    private String underProductLevelCode;

    @ApiModelProperty("产品层级编码集合（查询全部下级层级（含当前））")
    private List<String> underProductLevelCodeList;

    @ApiModelProperty("商品类型（精确查询）")
    private String productType;

    @ApiModelProperty("销售单位（精确查询）")
    private String saleUnit;

    @ApiModelProperty("基本单位（精确查询）")
    private String baseUnit;

    @ApiModelProperty("上下架状态（精确查询）")
    private String isShelf;

    @ApiModelProperty("条形码（精确查询）")
    private String barCode;

    @ApiModelProperty("销售公司（精确查询）")
    private String saleCompany;

    @ApiModelProperty("是否维护图片1是0否（精确查询）")
    private String maintenancePicture;

    @ApiModelProperty("是否维护详情1是0否（精确查询）")
    private String maintenanceIntroduction;

    @ApiModelProperty("生效状态（精确查询）")
    private String enableStatus;
}