package com.biz.crm.nebular.sfa.asexecution.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 方案活动兑付;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAsCashingReqVo", description = "方案活动兑付;")
public class SfaAsCashingReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("转账金额")
    private BigDecimal transferAmount;

    @ApiModelProperty("方案活动兑付产品")
    private List<SfaAsCashingProductReqVo> asCashingProductList;

    @ApiModelProperty("方案活动兑付图片")
    private List<SfaAsCashingPictureReqVo> asCashingPictureList;




}