package com.biz.crm.nebular.tpm.liqueuraudit.resp;

import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 酒类tpm核销明细表返回vo
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类tpm核销明细表" )
@SaturnEntity(name = "TpmLiqueurAuditDetailsRespVo", description = "酒类tpm核销明细表" )
public class TpmLiqueurAuditDetailsRespVo extends TpmLiqueurActRegisterDetailRespVo {
    @ApiModelProperty("核销申请编码" )
    @SaturnColumn(description = "核销申请编码" )
    private String auditCode;

    @ApiModelProperty("活动登记明细编码" )
    @SaturnColumn(description = "活动登记明细编码" )
    private String actDetailCode;

    @ApiModelProperty("活动编码" )
    @SaturnColumn(description = "活动编码" )
    private String actCode;

    @ApiModelProperty("活动登记编码" )
    @SaturnColumn(description = "活动登记编码" )
    private String actRegisterCode;

    @ApiModelProperty("核销金额" )
    @SaturnColumn(description = "核销金额" )
    private BigDecimal amount;

    @ApiModelProperty("是否完全核销（Y/N）" )
    @SaturnColumn(description = "是否完全核销（Y/N）" )
    private String isAllAudit;

    @ApiModelProperty("已上账金额" )
    @SaturnColumn(description = "已上账金额" )
    private BigDecimal feeUsed;

    @ApiModelProperty("是否完全上账（Y/N）" )
    @SaturnColumn(description = "是否完全上账（Y/N）" )
    private String isAllFeeUsed;

    @ApiModelProperty("支付方式(字典编码)" )
    private String payType;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

}