package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池使用金额回退请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolUseBackReqVo", description = "费用池使用金额部分回退请求VO")
public class FeePoolUseBackReqVo {

    @ApiModelProperty("操作类型（必填）")
    private String operationType;

    @ApiModelProperty("来源单号（必填）")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("折扣回退金额")
    private BigDecimal discountBackAmount;

    @ApiModelProperty("货补回退金额明细")
    private List<FeePoolGoodsUseBackItemReqVo> goodsBackItemList;

}