package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "小程序App报表")
@SaturnEntity(name = "MdmCustomerCountRespVo", description = "小程序App报表")
public class MdmCustomerCountRespVo extends CrmExtVo {

    @ApiModelProperty("客户数量")
    private BigDecimal customerNumber = BigDecimal.ZERO;

    @ApiModelProperty("上期客户数量")
    private BigDecimal thanCustNumber = BigDecimal.ZERO;

    @ApiModelProperty("客户数增量")
    private BigDecimal fluctuateNumber = BigDecimal.ZERO;

    @ApiModelProperty("计划拜访数")
    private BigDecimal planVisitNumber = BigDecimal.ZERO;

    @ApiModelProperty("实际拜访数")
    private BigDecimal actualVisitNumber = BigDecimal.ZERO;

    @ApiModelProperty("计划完成率")
    private BigDecimal visitCompletionRate = BigDecimal.ZERO;

    @ApiModelProperty("查询下单数")
    private BigDecimal placeOrderNumber = BigDecimal.ZERO;

    @ApiModelProperty("销售达成率")
    private BigDecimal salesReachRate = BigDecimal.ZERO;

    @ApiModelProperty("被拜访过的客户数")
    private BigDecimal visitCustNumber = BigDecimal.ZERO;

    @ApiModelProperty("拜访覆盖率")
    private BigDecimal visitCoverRate = BigDecimal.ZERO;

}