package com.biz.crm.nebular.mdm.terminal;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Liao Hua
 * @date 2020/9/3 11:18 上午
 */
@Data
@EqualsAndHashCode(callSuper = false)
@CrmColumnResolve
public class MdmTerminalContactPageReqVo extends PageVo {

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位编码集合")
    private List<String> positionCodeList;
   
    @ApiModelProperty("终端编码")
    private List<String> terminalCodeList;

    @ApiModelProperty("终端名称或联系人名称")
    private String terminalOrContactName;

    @ApiModelProperty("终端编码或名称")
    private String terminalCodeOrName;

    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("距离")
    private Long distance;

    @ApiModelProperty("需要过滤的终端编码集合")
    private List<String> exclusiveTerminalCodeList;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;
}
