package com.biz.crm.nebular.sfa.asexecution.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 方案活动协议;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAsTreatyReqVo", description = "方案活动协议;")
public class SfaAsTreatyReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("陈列品牌")
    private String displayBrand;

    @ApiModelProperty("陈列品项")
    private String displayItem;

    @ApiModelProperty("陈列位置")
    private String  displayPlace;

    @ApiModelProperty("陈列规格")
    private String  displaySpecs;

    @ApiModelProperty("陈列件数")
    private String  displayNumber;

    @ApiModelProperty("陈列开始时间")
    private String  displayStartTime;

    @ApiModelProperty("陈列结束时间")
    private String  displayEndTime;

    @ApiModelProperty("陈列月份")
    private String  displayMonth;


    /**根据活动申请时选择的兑付方式进行展示对应的协议**/
    /**现金兑付*/
    @ApiModelProperty("每月支付现金")
    private BigDecimal monthPayAmount;

    @ApiModelProperty("合计奖励现金")
    private BigDecimal totalAmount;

    @ApiModelProperty("奖励收款人")
    private String payee;

    @ApiModelProperty("联系电话")
    private String contactPhone;

    /**货品兑付*/
    @ApiModelProperty("方案活动协议-货物兑换产品")
    private List<SfaAsTreatyConvertProductReqVo> asTreatyConvertProductList;

    @ApiModelProperty("方案活动协议-陈列产品")
    private List<SfaAsTreatyDisplayProductReqVo> asTreatyDisplayProductList;

    @ApiModelProperty("方案活动协议签字图片地址")
    private SfaAsTreatySignReqVo asTreatySign;

}