package com.biz.crm.nebular.sfa.visitstep.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 拜访步骤(订单主表);返回vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "订单明细返回vo")
@SaturnEntity(name = "SfaVisitStepOrderDetailRespVo", description = "订单明细返回vo")
public class SfaVisitStepOrderDetailRespVo{

    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("订单编码")
    private String orderCode;

    @ApiModelProperty("下单时间")
    private String orderTime;

    @ApiModelProperty("客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称")
    private String clientName;

    @ApiModelProperty("客户类型")
    private String clientType;

    @ApiModelProperty("客户图片")
    private String clientPhoto;

    @ApiModelProperty("上级客户编码")
    @SaturnColumn(description = "上级客户编码")
    private String customerCode;

    @ApiModelProperty("上级客户名称")
    @SaturnColumn(description = "上级客户名称")
    private String customerName;

    @ApiModelProperty("联系人")
    @SaturnColumn(description = "联系人")
    private String contacts;

    @ApiModelProperty("联系电话")
    @SaturnColumn(description = "联系电话")
    private String telephone;

    @ApiModelProperty("收货地址")
    @SaturnColumn(description = "收货地址")
    private String address;

    @ApiModelProperty("期望收货时间")
    @SaturnColumn(description = "期望收货时间")
    private String expectReceive;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("审批状态")
    private String approvalStatus;

    @ApiModelProperty("审批状态名称")
    private String approvalStatusName;

    @ApiModelProperty("工作流返回流程key")
    private String processNo;

    @ApiModelProperty("订单来源")
    private String orderSource;

    @ApiModelProperty("订单来源名称")
    private String orderSourceName;

    @ApiModelProperty("订单总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("产品明细列表")
    private List<SfaVisitStepOrderItemRespVo> sfaVisitStepOrderItemRespVos;

}