package com.biz.crm.nebular.sfa.actscheme.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsStopRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsTreatyRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsStopRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;

/**
 * 方案活动申请;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动申请;")
@SaturnEntity(name = "SfaActSchemePosApplyRespVo", description = "方案活动申请;")
public class SfaActSchemePosApplyRespVo extends CrmExtTenVo {


    @ApiModelProperty("方案编码")
    @SaturnColumn(description = "方案编码")
    private String schemeCode;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String activityName;

    @ApiModelProperty("活动类型")
    @SaturnColumn(description = "活动类型")
    private String activityType;

    @ApiModelProperty("活动类型描述")
    @SaturnColumn(description = "活动类型描述")
    @CrmDict(typeCode = "scheme_type",dictCodeField = "activityType")
    private String activityTypeDesc;

    @ApiModelProperty("门店类型")
    @SaturnColumn(description = "门店类型")
    private String terminalType;

    @ApiModelProperty("门店类型描述")
    @SaturnColumn(description = "门店类型描述")
    private String terminalTypeDesc;

    @ApiModelProperty("门店类型集合")
    @SaturnColumn(description = "门店类型集合")
    private List<String> terminalTypeList;

    @ApiModelProperty("门店类型描述集合")
    @SaturnColumn(description = "门店类型描述集合")
    private List<String> terminalTypeDescList;

    @ApiModelProperty("OA核销号")
    @SaturnColumn(description = "OA核销号")
    private String oaAuditCode;

    @ApiModelProperty("活动费用")
    @SaturnColumn(description = "活动费用")
    private String actCostAmount;

    @ApiModelProperty("计划销量")
    @SaturnColumn(description = "计划销量")
    private String planSalesVolume;

    @ApiModelProperty("单箱成本")
    @SaturnColumn(description = "单箱成本")
    private String singleCost;

    @ApiModelProperty("陈列类型")
    @SaturnColumn(description = "陈列类型")
    private String displayType;

    @ApiModelProperty("陈列类型描述")
    @SaturnColumn(description = "陈列类型描述")
    private String displayTypeDesc;

    @ApiModelProperty("陈列类型集合")
    @SaturnColumn(description = "陈列类型集合")
    private List<String> displayTypeList;

    @ApiModelProperty("陈列类型描述集合")
    @SaturnColumn(description = "陈列类型描述集合")
    private List<String> displayTypeDescList;

    @ApiModelProperty("计划投入门店数量")
    @SaturnColumn(description = "计划投入门店数量")
    private String planTermNum;

    @ApiModelProperty("兑付方式")
    @SaturnColumn(description = "兑付方式")
    private String paymentMethod;

    @ApiModelProperty("兑付方式描述")
    @SaturnColumn(description = "兑付方式描述")
    private String paymentMethodDesc;

    @ApiModelProperty("参与终端数量")
    @SaturnColumn(description = "参与终端数量")
    private String actualTermNum;

    @ApiModelProperty("活动执行开始时间")
    @SaturnColumn(description = "活动执行开始时间")
    private String activityStartTime;

    @ApiModelProperty("活动执行结束时间")
    @SaturnColumn(description = "活动执行结束时间")
    private String activityEndTime;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("审批状态")
    @SaturnColumn(description = "审批状态")
    private String bpmState;

    @ApiModelProperty("流程编号")
    @SaturnColumn(description = "流程编号")
    private String processCode;

    @ApiModelProperty("审批状态描述")
    @SaturnColumn(description = "审批状态描述")
    @CrmDict(typeCode = "bpm_status",dictCodeField = "bpmState")
    private String bpmStateDesc;

    @ApiModelProperty("活动结案状态(0:未结案；1：结案)")
    @SaturnColumn(description = "活动结案状态(0:未结案；1：结案)")
    public String endCaseState;

    @ApiModelProperty("活动描述")
    @SaturnColumn(description = "活动描述")
    private String describe;

    @ApiModelProperty("活动方案")
    @SaturnColumn(description = "活动方案")
    private SfaActSchemeRespVo sfaActSchemeRespVo;

    @ApiModelProperty("方案活动执行参与类型集合")
    @SaturnColumn(description = "方案活动执行参与类型集合")
    private Map<String, String> participateInTypeMap;

    @ApiModelProperty("已参与类型（0_免费参与/1_协议参与）")
    @SaturnColumn(description = "已参与类型")
    private String participateInType;

    @ApiModelProperty("兑付方式集合")
    @SaturnColumn(description = "兑付方式集合")
    private Map<String, String> paymentMethodMap;

    @ApiModelProperty("活动方案套餐列表")
    @SaturnColumn(description = "活动方案套餐列表")
    private List<SfaActSchemeSetmealRespVo> actSchemeSetmealList;

    @ApiModelProperty("参与列表")
    @SaturnColumn(description = "参与列表")
    private List<SfaAsStopRespVo> asStopList;




}