package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 方案活动终止;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动协议;")
@SaturnEntity(name = "SfaAsStopRespVo", description = "方案活动终止;")
public class SfaAsStopRespVo extends CrmExtTenVo {

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String activityCode;

    @ApiModelProperty("终端编码")
    @SaturnColumn(description = "终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    @SaturnColumn(description = "终端名称")
    private String terminalName;

    @ApiModelProperty("终结状态(0:未终止;1:终止)")
    @SaturnColumn(description = "终结状态(0:未终止;1:终止)")
    private String stopState;

    @ApiModelProperty("终止时间")
    @SaturnColumn(description = "终止时间")
    private String stopDate;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("活动参与情况")
    @SaturnColumn(description = "活动参与情况")
    private String actualSituation;
}