package com.biz.crm.nebular.sfa.helpdefense.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 拜访-协防执行;返回vo
 *
 * @author lf
 * @date 2021-01-11 15:42:32
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访-协防执行;")
@SaturnEntity(name = "SfaVisitHelpDefenseRespVo", description = "拜访-协防执行;")
public class SfaVisitHelpDefenseRespVo extends CrmExtTenVo {
    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("被协防人员账号")
    @SaturnColumn(description = "被协防人员账号")
    private String coverHelpUserName;

    @ApiModelProperty("被协防人员姓名")
    @SaturnColumn(description = "被协防人员姓名")
    private String coverHelpRealName;

    @ApiModelProperty("被协防组织编码")
    @SaturnColumn(description = "被协防组织编码")
    private String coverHelpOrgCode;

    @ApiModelProperty("被协防组织名称")
    @SaturnColumn(description = "被协防组织名称")
    private String coverHelpOrgName;

    @ApiModelProperty("被协防职位编码")
    @SaturnColumn(description = "被协防职位编码")
    private String coverHelpPosCode;

    @ApiModelProperty("被协防职位名称")
    @SaturnColumn(description = "被协防职位名称")
    private String coverHelpPosName;

    @ApiModelProperty("协防日期")
    @SaturnColumn(description = "协防日期")
    private String defenseDate;

    @ApiModelProperty("协防明细id")
    private String helpDefenseDetailId;

    @ApiModelProperty("协防状态(1-协防中,2-已完成)")
    @SaturnColumn(description = "协防状态(1-协防中,2-已完成)")
    private String helpDefenseStatus;

    @ApiModelProperty("协防状态")
    @CrmDict(typeCode = "help_defense_status",dictCodeField = "helpDefenseStatus")
    private String helpDefenseStatusDesc;

    @ApiModelProperty("客户id;客户id")
    @SaturnColumn(description = "客户id;客户id")
    private String clientId;

    @ApiModelProperty("客户编码;协防客户编码")
    @SaturnColumn(description = "客户编码;协防客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称;协访客户名称")
    @SaturnColumn(description = "客户名称;协访客户名称")
    private String clientName;

    @ApiModelProperty("客户类型;协访客户类型")
    @SaturnColumn(description = "客户类型;协访客户类型")
    private String clientType;

    @ApiModelProperty("客户电话 客户电话")
    @SaturnColumn(description = "客户电话 客户电话")
    private String clientPhone;

    @ApiModelProperty("客户地址;客户地址")
    @SaturnColumn(description = "客户地址;客户地址")
    private String clientAddress;

    @ApiModelProperty("协防总结")
    @SaturnColumn(description = "协防总结")
    private String helpDefenseSummary;

    @ApiModelProperty("重点问题记录")
    @SaturnColumn(description = "重点问题记录")
    private String keyQuestions;

    @ApiModelProperty("进店时间")
    @SaturnColumn(description = "进店时间")
    private String inStore;

    @ApiModelProperty("进店地址")
    @SaturnColumn(description = "进店地址")
    private String inStoreAddress;

    @ApiModelProperty("进店地址经度;进店地址协访客户经度")
    @SaturnColumn(description = "进店地址经度;进店地址协访客户经度")
    private BigDecimal inStoreLongitude;

    @ApiModelProperty("进店地址纬度;进店地址协访客户纬度")
    @SaturnColumn(description = "进店地址纬度;进店地址协访客户纬度")
    private BigDecimal inStoreLatitude;

    @ApiModelProperty("离店时间")
    @SaturnColumn(description = "离店时间")
    private String outStore;

    @ApiModelProperty("离店地址")
    @SaturnColumn(description = "离店地址")
    private String outStoreAddress;

    @ApiModelProperty("离店地址经度;进店地址协访客户经度")
    @SaturnColumn(description = "离店地址经度;进店地址协访客户经度")
    private BigDecimal outStoreLongitude;

    @ApiModelProperty("离店地址纬度;进店地址协访客户纬度")
    @SaturnColumn(description = "离店地址纬度;进店地址协访客户纬度")
    private BigDecimal outStoreLatitude;

    @ApiModelProperty("距离")
    private BigDecimal distance;

    @ApiModelProperty("按钮")
    private Map<String,String> buttons;

    @ApiModelProperty("协防总条数")
    private Integer helpDefenseTotal;

    @ApiModelProperty("协防完成条数")
    private Integer helpDefenseSuccess;

    @ApiModelProperty("客户经度")
    private String longitude;

    @ApiModelProperty("客户维度")
    private String latitude;

    @ApiModelProperty("协防明细信息列表")
    private List<SfaVisitHelpDefenseDetailRespVo> sfaVisitHelpDefenseDetailList;

    @ApiModelProperty("进店打卡图片地址")
    private List<String> inStorePicList;

    @ApiModelProperty("离店打卡图片地址")
    private List<String> outStorePicList;

    @ApiModelProperty("合格率")
    private BigDecimal qualifiedNum;

}