package com.biz.crm.nebular.sfa.worksummary.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工作总结可见权限返回vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作总结可见权限")
@SaturnEntity(name = "SfaWorkSummaryScopeRespVo", description = "工作总结可见权限")
public class SfaWorkSummaryScopeRespVo extends CrmBaseVo {
    private static final long serialVersionUID = -1522088209477279996L;
    @ApiModelProperty("权限类型")
    @SaturnColumn(description = "权限类型")
    private String scopeType;

    @ApiModelProperty("权限范围code（组织code/人员code）")
    @SaturnColumn(description = "权限范围code（组织code/人员code）")
    private String scopeCode;

    @ApiModelProperty("计数")
    @SaturnColumn(description = "计数")
    private Integer scopeCount;

    @ApiModelProperty("工作总结动态ID")
    @SaturnColumn(description = "工作总结动态ID")
    private String businessId;

}